import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/helper/date_converter.dart';
import 'package:viserpay/core/helper/string_format_helper.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/status.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/core/utils/url_container.dart';
import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/model/savings/savings_history_response_model.dart';
import 'package:viserpay/view/components/animated_widget/expanded_widget.dart';
import 'package:viserpay/view/components/column_widget/card_column.dart';
import 'package:viserpay/view/components/divider/custom_divider.dart';
import 'package:viserpay/view/components/image/my_image_widget.dart';

class DpsHistoryWidget extends StatelessWidget {
  final DpsHistoryData dps;
  final String currency;
  final String imagePath;
  final bool showStatus;
  final VoidCallback onTap;
  const DpsHistoryWidget({
    super.key,
    required this.dps,
    required this.currency,
    required this.imagePath,
    required this.onTap,
    this.showStatus = false,
  });

  @override
  Widget build(BuildContext context) {
    return InkWell(
      onTap: onTap,
      child: Container(
        padding: EdgeInsets.symmetric(horizontal: Dimensions.space15, vertical: Dimensions.space15),
        decoration: BoxDecoration(
          color: MyColor.colorWhite,
          borderRadius: BorderRadius.circular(Dimensions.mediumRadius),
        ),
        child: Column(
          spacing: 5,
          children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                MyImageWidget(
                  imageUrl: imagePath,
                  radius: 10,
                  height: 50,
                  width: 80,
                ),
                const SizedBox(width: Dimensions.space10),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(dps.dpsPlan?.organization?.name ?? '', style: semiBoldDefault.copyWith(color: MyColor.colorGrey), maxLines: 1, overflow: TextOverflow.ellipsis),
                      SizedBox(height: 5),
                      Text('#${dps.accountId}', style: lightDefault.copyWith(color: MyColor.colorGrey), maxLines: 1, overflow: TextOverflow.ellipsis),
                      Text(DateConverter.convertIsoToString(dps.createdAt ?? ''), style: lightDefault.copyWith(color: MyColor.colorGrey), maxLines: 1, overflow: TextOverflow.ellipsis),
                    ],
                  ),
                ),
                if (showStatus) accountStatusWidget(dps.status ?? ''),
              ],
            ),
            CustomDivider(space: 10),
            Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                CardColumn(
                  header: "$currency${StringConverter.formatNumber(dps.dpsPlan?.installmentAmount ?? '')}",
                  body: (dps.dpsPlan?.interval?.name ?? "").tr,
                  headerTextStyle: semiBoldDefault.copyWith(fontSize: 15),
                  bodyTextStyle: lightDefault.copyWith(fontSize: 14),
                ),
                CardColumn(
                  alignmentEnd: true,
                  header: 'Mature Amount', //dps.dpsPlan?.tenure?.name ??
                  body: "$currency${StringConverter.formatNumber(dps.dpsPlan?.maturityAmount ?? '')}",
                  headerTextStyle: semiBoldDefault.copyWith(fontSize: 15),
                  bodyTextStyle: lightDefault.copyWith(fontSize: 14),
                ),
              ],
            )
          ],
        ),
      ),
    );
  }

  Widget accountStatusWidget(String status) {
    return Container(
      padding: EdgeInsets.symmetric(horizontal: Dimensions.space10, vertical: Dimensions.space5),
      decoration: BoxDecoration(
        color: status == MyStatus.ACCOUNT_CLOSED ? MyColor.redCancelTextColor.withValues(alpha: 0.1) : MyColor.greenSuccessColor.withValues(alpha: 0.1),
        border: Border.all(color: status == MyStatus.ACCOUNT_CLOSED ? MyColor.redCancelTextColor : MyColor.greenSuccessColor, width: .5),
        borderRadius: BorderRadius.circular(Dimensions.defaultRadius),
      ),
      child: Text(
        status == MyStatus.ACCOUNT_CLOSED ? "Closed" : "Matured",
        style: regularDefault.copyWith(color: status == MyStatus.ACCOUNT_CLOSED ? MyColor.redCancelTextColor : MyColor.greenSuccessColor),
      ),
    );
  }

  Widget customRow({required String title, required String value, bool showDivider = true, TextStyle? valueTextStyle}) {
    return Column(
      children: [
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Text(title, style: semiBoldDefault.copyWith(fontSize: Dimensions.fontLarge - 1, color: MyColor.colorGrey)),
            Text(value, style: valueTextStyle ?? lightDefault.copyWith(fontSize: Dimensions.fontLarge - 1, color: MyColor.colorGrey)),
          ],
        ),
        if (showDivider) CustomDivider(space: 10),
      ],
    );
  }

  Widget dpsStatus(String status) {
    return Container(
      padding: EdgeInsets.symmetric(horizontal: Dimensions.space10, vertical: Dimensions.space5),
      decoration: BoxDecoration(
        color: MyStatus.ACCOUNT_ACTIVE == status ? MyColor.greenSuccessColor.withValues(alpha: 0.1) : MyColor.colorRed.withValues(alpha: 0.1),
        borderRadius: BorderRadius.circular(Dimensions.mediumRadius),
        border: Border.all(color: MyStatus.ACCOUNT_ACTIVE == status ? MyColor.greenSuccessColor : MyColor.colorRed, width: .5),
      ),
      child: Text(
        MyStatus.ACCOUNT_ACTIVE == status ? MyStrings.active.tr : MyStrings.closed.tr,
        style: regularDefault.copyWith(color: MyStatus.ACCOUNT_ACTIVE == status ? MyColor.greenSuccessColor : MyColor.colorRed),
      ),
    );
  }
}
